<?php
require __DIR__ . "/db.php";
require __DIR__ . "/admin_config.php";

$input = json_decode(file_get_contents("php://input"), true);
$pass = $input["pass"] ?? "";
$token = $input["token"] ?? "";

if ($pass !== ADMIN_PASS) { http_response_code(401); echo json_encode(["error"=>"Unauthorized"]); exit; }
if ($token === "") { http_response_code(400); echo json_encode(["error"=>"Token required"]); exit; }

$att = $pdo->prepare("SELECT id, token, student_name, student_id, started_at, last_seen, violations,
                             is_submitted, objective_score, disqualified, disqual_reason,
                             ip_address, user_agent
                      FROM attempts WHERE token=?");
$att->execute([$token]);
$a = $att->fetch();
if (!$a) { http_response_code(404); echo json_encode(["error"=>"Attempt not found"]); exit; }

$attempt_id = (int)$a["id"];

$ans = $pdo->prepare("SELECT qtype, qindex, answer_text, updated_at FROM answers
                      WHERE attempt_id=? ORDER BY qtype, qindex");
$ans->execute([$attempt_id]);
$answers = $ans->fetchAll();

$sn = $pdo->prepare("SELECT image_path, created_at FROM webcam_snaps
                     WHERE attempt_id=? ORDER BY created_at DESC LIMIT 30");
$sn->execute([$attempt_id]);
$snaps = $sn->fetchAll();

echo json_encode(["attempt"=>$a, "answers"=>$answers, "snaps"=>$snaps]);
