<?php
require __DIR__ . "/db.php";

$MAX_VIOLATIONS = 3;

$input = json_decode(file_get_contents("php://input"), true);
$token = $input["token"] ?? "";
$addViolation = (int)($input["violation"] ?? 0);
$reason = trim($input["reason"] ?? "");

$att = $pdo->prepare("SELECT id, violations, disqualified, is_submitted FROM attempts WHERE token=?");
$att->execute([$token]);
$row = $att->fetch();
if (!$row) { http_response_code(404); echo json_encode(["error"=>"Attempt not found"]); exit; }

$attempt_id = (int)$row["id"];
$viol = (int)$row["violations"] + ($addViolation ? 1 : 0);
$now = date("Y-m-d H:i:s");

// if already submitted/disqualified just update last_seen
if ((int)$row["is_submitted"] === 1) {
  $pdo->prepare("UPDATE attempts SET last_seen=? WHERE id=?")->execute([$now, $attempt_id]);
  echo json_encode(["ok"=>true, "violations"=>$viol, "disqualified"=>(int)$row["disqualified"]]);
  exit;
}

$disq = (int)$row["disqualified"];
$disqReason = null;

if ($viol >= $MAX_VIOLATIONS && $disq === 0) {
  $disq = 1;
  $disqReason = $reason !== "" ? $reason : "Exceeded violation limit";
}

if ($disq === 1) {
  $pdo->prepare("UPDATE attempts
    SET last_seen=?, violations=?, disqualified=1, disqual_reason=?, is_submitted=1
    WHERE id=?")->execute([$now, $viol, $disqReason, $attempt_id]);

  echo json_encode(["ok"=>true, "violations"=>$viol, "disqualified"=>1, "reason"=>$disqReason]);
  exit;
}

$pdo->prepare("UPDATE attempts SET last_seen=?, violations=? WHERE id=?")->execute([$now, $viol, $attempt_id]);
echo json_encode(["ok"=>true, "violations"=>$viol, "disqualified"=>0]);
