<?php
require __DIR__ . "/db.php";

$input = json_decode(file_get_contents("php://input"), true);
$token = $input["token"] ?? "";
$qtype = $input["qtype"] ?? "";
$qindex = (int)($input["qindex"] ?? -1);
$answer = $input["answer"] ?? "";

if ($token === "" || ($qtype !== "mcq" && $qtype !== "theory") || $qindex < 0) {
  http_response_code(400); echo json_encode(["error"=>"Bad request"]); exit;
}

$att = $pdo->prepare("SELECT id FROM attempts WHERE token=?");
$att->execute([$token]);
$row = $att->fetch(PDO::FETCH_ASSOC);
if (!$row) { http_response_code(404); echo json_encode(["error"=>"Attempt not found"]); exit; }
$attempt_id = (int)$row["id"];

$now = date("Y-m-d H:i:s");

$stmt = $pdo->prepare("
  INSERT INTO answers(attempt_id, qtype, qindex, answer_text, updated_at)
  VALUES(?,?,?,?,?)
  ON DUPLICATE KEY UPDATE answer_text=VALUES(answer_text), updated_at=VALUES(updated_at)
");
$stmt->execute([$attempt_id, $qtype, $qindex, $answer, $now]);

$pdo->prepare("UPDATE attempts SET last_seen=? WHERE id=?")->execute([$now, $attempt_id]);

echo json_encode(["ok"=>true]);
