<?php
require __DIR__ . "/db.php";

$input = json_decode(file_get_contents("php://input"), true);
$name = trim($input["name"] ?? "");
$sid  = trim($input["studentId"] ?? "");

if ($name === "") { http_response_code(400); echo json_encode(["error"=>"Name required"]); exit; }

$token = bin2hex(random_bytes(16));
$now = date("Y-m-d H:i:s");

$ip = $_SERVER["REMOTE_ADDR"] ?? null;
$ua = $_SERVER["HTTP_USER_AGENT"] ?? null;

$stmt = $pdo->prepare("INSERT INTO attempts(token, student_name, student_id, started_at, last_seen, ip_address, user_agent)
                       VALUES(?,?,?,?,?,?,?)");
$stmt->execute([$token, $name, $sid, $now, $now, $ip, $ua]);

echo json_encode(["token"=>$token]);
