<?php
require __DIR__ . "/db.php";

$input = json_decode(file_get_contents("php://input"), true);
$token = $input["token"] ?? "";
$objectiveScore = (int)($input["objectiveScore"] ?? 0);

$att = $pdo->prepare("SELECT id FROM attempts WHERE token=?");
$att->execute([$token]);
$row = $att->fetch(PDO::FETCH_ASSOC);
if (!$row) { http_response_code(404); echo json_encode(["error"=>"Attempt not found"]); exit; }

$attempt_id = (int)$row["id"];
$now = date("Y-m-d H:i:s");

$pdo->prepare("UPDATE attempts SET is_submitted=1, objective_score=?, last_seen=? WHERE id=?")
  ->execute([$objectiveScore, $now, $attempt_id]);

echo json_encode(["ok"=>true]);
