<?php
require __DIR__ . "/db.php";

$token = $_POST["token"] ?? "";
$data  = $_POST["image"] ?? ""; // dataURL

$att = $pdo->prepare("SELECT id FROM attempts WHERE token=?");
$att->execute([$token]);
$row = $att->fetch(PDO::FETCH_ASSOC);
if (!$row) { http_response_code(404); echo json_encode(["error"=>"Attempt not found"]); exit; }
$attempt_id = (int)$row["id"];

if (strpos($data, "data:image/jpeg;base64,") !== 0) {
  http_response_code(400); echo json_encode(["error"=>"Bad image"]); exit;
}

$raw = base64_decode(substr($data, strlen("data:image/jpeg;base64,")));
$dir = __DIR__ . "/../snaps";
if (!is_dir($dir)) mkdir($dir, 0755, true);

$filename = "snap_" . $attempt_id . "_" . time() . ".jpg";
file_put_contents($dir . "/" . $filename, $raw);

$now = date("Y-m-d H:i:s");
$pdo->prepare("INSERT INTO webcam_snaps(attempt_id, image_path, created_at) VALUES(?,?,?)")
  ->execute([$attempt_id, "snaps/".$filename, $now]);

echo json_encode(["ok"=>true]);

