let adminPass = "";
let selectedToken = null;
let pollTimer = null;

// ---- COPY SAME MCQS HERE (must match exam app.js) ----
const mcqs = [
    { q: "What does HTML stand for?", a: ["Hyperlinks and Text Markup Language", "HyperText Markup Language", "Home Tool Markup Language", "Hyper Transfer Markup Language"], correct: 1 },
    { q: "Which tag is used to create a hyperlink?", a: ["<link>", "<a>", "<href>", "<url>"], correct: 1 },
    { q: "Which attribute is used to provide an image source?", a: ["href", "src", "alt", "link"], correct: 1 },
    { q: "Which tag is best for the main heading of a page?", a: ["<h6>", "<head>", "<h1>", "<title>"], correct: 2 },
    { q: "Which element is used to create an ordered list?", a: ["<ul>", "<ol>", "<li>", "<dl>"], correct: 1 },
    { q: "Which tag is used for a line break?", a: ["<br>", "<hr>", "<break>", "<lb>"], correct: 0 },
    { q: "Which is a semantic element?", a: ["<div>", "<span>", "<section>", "<b>"], correct: 2 },
    { q: "Which attribute makes an input mandatory?", a: ["must", "required", "validate", "needed"], correct: 1 },
    { q: "Which tag holds metadata and links to CSS?", a: ["<body>", "<main>", "<head>", "<footer>"], correct: 2 },
    { q: "What is the correct doctype for HTML5?", a: ["<!DOCTYPE html>", "<!DOCTYPE HTML5>", "<!DOCTYPE web>", "<!DOC html>"], correct: 0 },

    { q: "CSS stands for:", a: ["Creative Style Sheets", "Cascading Style Sheets", "Computer Style System", "Colorful Style Sheets"], correct: 1 },
    { q: "Which CSS property changes text color?", a: ["font-color", "text-color", "color", "fgcolor"], correct: 2 },
    { q: "Which selector targets an element with id='box'?", a: [".box", "#box", "box", "*box"], correct: 1 },
    { q: "Which property controls spacing inside the border?", a: ["margin", "padding", "gap", "outline"], correct: 1 },
    { q: "Which property controls spacing outside the border?", a: ["margin", "padding", "spacing", "border-gap"], correct: 0 },
    { q: "Which layout uses rows/columns explicitly?", a: ["Float", "Flexbox", "Grid", "Position"], correct: 2 },
    { q: "Which unit is relative to the root font size?", a: ["em", "rem", "px", "vh"], correct: 1 },
    { q: "To make text bold in CSS you can use:", a: ["font-style: bold;", "font-weight: bold;", "text-weight: bold;", "font-bold: true;"], correct: 1 },
    { q: "Which property makes corners rounded?", a: ["corner-radius", "border-round", "border-radius", "radius"], correct: 2 },
    { q: "Media queries are used for:", a: ["Animations", "Responsive design", "Database queries", "Linking JS"], correct: 1 },

    { q: "JavaScript is mainly used to:", a: ["Style pages", "Structure pages", "Add interactivity", "Store images"], correct: 2 },
    { q: "Which keyword declares a block-scoped variable?", a: ["var", "let", "define", "int"], correct: 1 },
    { q: "Which is a correct function syntax?", a: ["function myFn() {}", "func myFn() {}", "def myFn() {}", "fn myFn() {}"], correct: 0 },
    { q: "What does DOM stand for?", a: ["Document Object Model", "Data Object Method", "Document Oriented Mode", "Display Object Management"], correct: 0 },
    { q: "How do you select an element by id in JS?", a: ["document.query('id')", "document.getElementById('id')", "document.getById('id')", "window.getElementById('id')"], correct: 1 },
    { q: "Which operator checks strict equality?", a: ["=", "==", "===", "!="], correct: 2 },
    { q: "What is the output type of prompt()?", a: ["Number", "String (or null)", "Boolean", "Object"], correct: 1 },
    { q: "Which converts '12' to number safely?", a: ["Number('12')", "toNumber('12')", "int('12')", "parse('12')"], correct: 0 },
    { q: "Which is NOT a JS data type?", a: ["String", "Boolean", "Float", "Undefined"], correct: 2 },
    { q: "Which method adds an item to end of array?", a: ["push()", "pop()", "shift()", "unshift()"], correct: 0 },
    { q: "Event listener syntax is:", a: ["element.on('click', fn)", "element.addEventListener('click', fn)", "element.listen('click', fn)", "element.click(fn)"], correct: 1 },
    { q: "JSON stands for:", a: ["Java Source Object Notation", "JavaScript Object Notation", "Joined String Object Notation", "JavaScript Ordered Name"], correct: 1 },

    { q: "WordPress is mainly a:", a: ["Programming language", "CMS (Content Management System)", "Database server", "Browser"], correct: 1 },
    { q: "In WordPress, a Theme controls:", a: ["Site appearance/layout", "Database backup", "Email sending", "DNS records"], correct: 0 },
    { q: "A plugin in WordPress is used to:", a: ["Change domain name", "Extend features/functionality", "Replace hosting", "Edit DNS"], correct: 1 },
    { q: "IP address is used to:", a: ["Style websites", "Identify a device on a network", "Encrypt CSS", "Create domains"], correct: 1 },
    { q: "DNS is best described as:", a: ["A programming language", "A system that translates domain names to IP addresses", "A hosting company", "A browser extension"], correct: 1 },
    { q: "A domain name is:", a: ["A website color scheme", "Human-friendly name for an IP (e.g., example.com)", "A file folder", "A CSS property"], correct: 1 },
    { q: "HTTP vs HTTPS: HTTPS is:", a: ["Slower always", "Encrypted/secure version of HTTP", "A different browser", "Only for emails"], correct: 1 },
    { q: "The internet is:", a: ["One big computer", "A global network of networks", "A single website", "A database tool"], correct: 1 },
];

async function apiPost(url, data) {
    const res = await fetch(url, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(data)
    });
    return res.json();
}

function escapeHtml(str) {
    return String(str)
        .replaceAll("&", "&amp;")
        .replaceAll("<", "&lt;")
        .replaceAll(">", "&gt;")
        .replaceAll('"', "&quot;")
        .replaceAll("'", "&#039;");
}

function badge(text, cls = "badge") {
    return `<span class="${cls}">${escapeHtml(text)}</span>`;
}

function wordCount(text) {
    const t = (text || "").trim();
    if (!t) return 0;
    return t.split(/\s+/).length;
}

async function loadAttempts() {
    if (!adminPass) return;

    const listEl = document.getElementById("attemptsList");
    listEl.innerHTML = `<div class="muted">Loading...</div>`;

    const resp = await apiPost("../api/list_attempts.php", { pass: adminPass });
    if (resp.error) {
        listEl.innerHTML = `<div class="muted">Error: ${escapeHtml(resp.error)}</div>`;
        return;
    }

    if (!resp.attempts || resp.attempts.length === 0) {
        listEl.innerHTML = `<div class="muted">No attempts yet.</div>`;
        return;
    }

    listEl.innerHTML = resp.attempts.map(a => {
        const status = a.disqualified == 1
            ? badge("DISQUALIFIED", "badge danger")
            : (a.is_submitted == 1 ? badge("SUBMITTED", "badge ok") : badge("LIVE", "badge"));

        const v = a.violations > 0 ? badge(`Violations: ${a.violations}`, "badge danger") : badge("No violations", "badge ok");

        return `
      <div class="item" data-token="${escapeHtml(a.token)}">
        <div class="top">
          <div><strong>${escapeHtml(a.student_name)}</strong> <span class="muted small">${escapeHtml(a.student_id || "")}</span></div>
          ${status}
        </div>
        <div class="muted small">Started: ${escapeHtml(a.started_at)}</div>
        <div class="muted small">Last seen: ${escapeHtml(a.last_seen)}</div>
        <div class="row" style="margin-top:6px;gap:6px;">
          ${v}
          ${badge(`Obj: ${a.objective_score}/40`, "badge")}
        </div>
      </div>
    `;
    }).join("");

    document.querySelectorAll(".item").forEach(el => {
        el.addEventListener("click", () => {
            selectedToken = el.getAttribute("data-token");
            document.getElementById("selectedHint").textContent = `Selected token: ${selectedToken}`;
            loadAttemptDetails();
        });
    });
}

async function loadAttemptDetails() {
    if (!adminPass || !selectedToken) return;

    const details = document.getElementById("detailsArea");
    details.innerHTML = `<div class="muted">Loading details...</div>`;

    const resp = await apiPost("../api/get_attempt.php", { pass: adminPass, token: selectedToken });
    if (resp.error) {
        details.innerHTML = `<div class="muted">Error: ${escapeHtml(resp.error)}</div>`;
        return;
    }

    const a = resp.attempt;
    const answers = resp.answers || [];
    const snaps = resp.snaps || [];

    const mcqAns = answers.filter(x => x.qtype === "mcq");
    const thAns = answers.filter(x => x.qtype === "theory");

    const mcqMap = new Map(mcqAns.map(x => [Number(x.qindex), x]));
    const thMap = new Map(thAns.map(x => [Number(x.qindex), x]));

    // compute objective from stored answers (dashboard-side)
    let computedScore = 0;
    for (let i = 0; i < mcqs.length; i++) {
        const row = mcqMap.get(i);
        if (!row) continue;
        const chosen = Number(row.answer_text);
        if (chosen === mcqs[i].correct) computedScore++;
    }

    const disqLine = a.disqualified == 1
        ? `<div class="pill"><div class="muted small">Disqualified</div><strong>YES</strong><div class="muted small">${escapeHtml(a.disqual_reason || "")}</div></div>`
        : `<div class="pill"><div class="muted small">Disqualified</div><strong>NO</strong></div>`;

    const latestSnap = snaps.length ? snaps[0].image_path : null;

    details.innerHTML = `
    <div class="split">
      <div class="pill"><div class="muted small">Student</div><strong>${escapeHtml(a.student_name)}</strong></div>
      <div class="pill"><div class="muted small">Student ID</div><strong>${escapeHtml(a.student_id || "-")}</strong></div>
      <div class="pill"><div class="muted small">IP</div><strong class="mono">${escapeHtml(a.ip_address || "-")}</strong></div>
      <div class="pill"><div class="muted small">User-Agent</div><div class="muted small">${escapeHtml(a.user_agent || "-")}</div></div>
      <div class="pill"><div class="muted small">Started</div><strong class="mono">${escapeHtml(a.started_at)}</strong></div>
      <div class="pill"><div class="muted small">Last seen</div><strong class="mono">${escapeHtml(a.last_seen)}</strong></div>
      <div class="pill"><div class="muted small">Violations</div><strong>${escapeHtml(String(a.violations))}</strong></div>
      <div class="pill"><div class="muted small">Submitted</div><strong>${a.is_submitted == 1 ? "YES" : "NO"}</strong></div>
      ${disqLine}
      <div class="pill"><div class="muted small">Objective (stored)</div><strong>${escapeHtml(String(a.objective_score))}/40</strong></div>
      <div class="pill"><div class="muted small">Objective (computed)</div><strong>${computedScore}/40</strong></div>
    </div>

    <h2 style="margin:14px 0 6px;">Webcam (latest + gallery)</h2>
    ${latestSnap ? `
      <div class="q">
        <div class="muted small">Latest snapshot</div>
        <img src="../${escapeHtml(latestSnap)}" style="max-width:100%;border-radius:12px;border:1px solid rgba(255,255,255,.12);" />
      </div>
    ` : `<div class="muted">No webcam snaps yet.</div>`}

    ${snaps.length ? `
      <div class="q">
        <div class="muted small">Gallery (last ${snaps.length})</div>
        <div style="display:flex;gap:10px;flex-wrap:wrap;margin-top:10px;">
          ${snaps.map(s => `
            <div style="width:160px">
              <img src="../${escapeHtml(s.image_path)}" style="width:160px;height:auto;border-radius:12px;border:1px solid rgba(255,255,255,.12);" />
              <div class="muted small mono" style="margin-top:4px;">${escapeHtml(s.created_at)}</div>
            </div>
          `).join("")}
        </div>
      </div>
    ` : ``}

    <h2 style="margin:14px 0 6px;">MCQ (question + selected + correct)</h2>
    ${mcqs.map((q, i) => {
        const row = mcqMap.get(i);
        const sel = row ? Number(row.answer_text) : null;
        const selText = (sel === null || Number.isNaN(sel)) ? "(not answered)" : q.a[sel];
        const correctText = q.a[q.correct];
        const isCorrect = sel === q.correct;

        const cls = sel === null ? "badge" : (isCorrect ? "badge ok" : "badge danger");
        const status = sel === null ? "NO ANSWER" : (isCorrect ? "CORRECT" : "WRONG");

        const updated = row ? row.updated_at : "-";

        return `
        <div class="q">
          <div class="row" style="justify-content:space-between;">
            <h3 style="margin:0;">Q${i + 1}. ${escapeHtml(q.q)}</h3>
            ${badge(status, cls)}
          </div>
          <div class="muted small mono">Last update: ${escapeHtml(updated)}</div>

          <div class="muted small" style="margin-top:6px;">Options:</div>
          <ol class="small" style="margin:6px 0 0 18px;">
            ${q.a.map((opt, idx) => `<li class="mono">${escapeHtml(opt)}</li>`).join("")}
          </ol>

          <div class="small" style="margin-top:8px;">
            <strong>Selected:</strong> <span class="mono">${escapeHtml(selText)}</span><br/>
            <strong>Correct:</strong> <span class="mono">${escapeHtml(correctText)}</span>
          </div>
        </div>
      `;
    }).join("")}

    <h2 style="margin:14px 0 6px;">Theory / Practical (with word count)</h2>
    ${Array.from({ length: 4 }).map((_, i) => {
        const row = thMap.get(i);
        const txt = row ? row.answer_text : "";
        const upd = row ? row.updated_at : "-";
        const wc = wordCount(txt);

        return `
        <div class="q">
          <h3>Theory Q${i + 1}</h3>
          <div class="muted small mono">Last update: ${escapeHtml(upd)} • Words: ${wc}</div>
          <pre class="mono" style="white-space:pre-wrap;margin:10px 0 0;">${escapeHtml(txt || "(no answer yet)")}</pre>
        </div>
      `;
    }).join("")}
  `;
}

function startPolling() {
    if (pollTimer) clearInterval(pollTimer);
    pollTimer = setInterval(async () => {
        await loadAttempts();
        if (selectedToken) await loadAttemptDetails();
    }, 3000);
}

document.getElementById("loginBtn").addEventListener("click", async () => {
    adminPass = document.getElementById("adminPass").value.trim();
    if (!adminPass) return alert("Enter admin password");

    await loadAttempts();
    startPolling();
});

document.getElementById("refreshBtn").addEventListener("click", loadAttempts);
document.getElementById("forceRefreshBtn").addEventListener("click", async () => {
    await loadAttempts();
    if (selectedToken) await loadAttemptDetails();
});
